/*
 * fc_usb_tcu_US_JSONParser.h
 *
 *  Created on: Mar 19, 2015
 *      Author: kl81hc
 */

#ifndef FC_USB_TCU_US_JSONPARSER_H_
#define FC_USB_TCU_US_JSONPARSER_H_

#include "I_fc_usb_tcu_JSONParser.h"

class fc_usb_tcu_US_JSONParser : public I_fc_usb_tcu_JSONParser
{
#if defined(VARIANT_S_FTR_ENABLE_FC_USB_TCU_FRIEND_CLASSES)
	friend class fc_usb_tcu_US_JSONParser_Test;
#endif
public:
	fc_usb_tcu_US_JSONParser(fc_usb_tcu_tclAppMain* poMainAppl);
	~fc_usb_tcu_US_JSONParser();

	tBool vParseChannelDataJSON(Json::Value& root, T_tcu_channel_data_result& oChannelData);
	tBool vParseChannelMasterDataJSON(Json::Value& root, T_tcu_channel_master_data_result& oChannelMasterData);

	virtual const tChar* getName() const { return "fc_usb_tcu_US_JSONParser"; };

	virtual tVoid vHandleMessage(fc_usb_tcu_tclBaseIf::TMsg* pMsg){(void)pMsg;}
	virtual tVoid vHandleTraceMessage(const tUChar* puchData){(void)puchData;}
	virtual tVoid vGetReferences(){;}
	virtual tVoid vStartCommunication(){;}
	virtual tVoid vTraceInfo(){;}
private:
	tBool parseChannelDataInformationHeaderPart(Json::Value & jChannelDataInformationHeaderPart, T_tcu_channel_data_information_header & oDest);
	tBool parseChannelDataInformationRecordPart(Json::Value & jChannelDataInformationRecordPart, T_tcu_channel_data_information & oDest);
	tBool parseChannelDataInformationRecordItem(Json::Value & jChannelDataInformationRecordPart, T_tcu_channel_data_information_record & oDest);
	tBool parseLocation(Json::Value & jChannelDataInformationRecordPart, T_tcu_Location& oLocation);
	tBool parseExecutionInformation(Json::Value & jChannelDataInformationRecordPart,T_tcu_Exection_Information& oExecutionInformation);
	tBool parseAutoPlay(Json::Value jAutoPlay, T_tcu_Auto_Play& oAutoPlay);
	tBool parseDispList(Json::Value jDispList, T_tcu_Disp_List& oDispList);
	tBool parseRouteCalc(Json::Value jRouteCalc, T_tcu_Route_Calc& oRouteCalc);

	tBool isJSONFormatValid(Json::Value & root);
	tVoid parseChannelMasterDataHeader(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData, tBool & bIsParsingSuccess);
	tVoid parseFolderDefinitionInformation(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData, tBool & bIsParsingSuccess);
	tVoid parseChannelDefinitionInformation(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData, tBool & bIsParsingSuccess);
	
	tBool vParseChargingStationsData(Json::Value& root, T_tcu_response_charging_stations_list_result& oChargingStationsData){
		(void)oChargingStationsData;
		return false;
	}
	tBool vParseChargingSpotData(Json::Value & ChargingSpotData, T_tcu_charging_spot& oChargingSpotData){
		(void)oChargingSpotData;
		return false;
	} ;
	tBool vParseVacantStationsData(Json::Value& root, T_tcu_response_vacancy_stations_list_result& oVacantStationsData){
		(void)oVacantStationsData;
		return false;
	}
	tBool vParseVICSData(Json::Value & VICSData, T_tcu_VICS_Response_Data& oVICSData) 
	{
		(void)oVICSData;
		return false;
	}
	tBool bParsePartAuthResponseJSON(Json::Value & response, T_tcu_PartAuthentication_Response_Data& tPartAuth)
	{
		(void)tPartAuth;
		return false;
	};
	tBool bParseUserAuthResponseJSON(Json::Value & response, T_tcu_UserAuthToken_Response_Data& tUserAuth)
	{
		(void)tUserAuth;
		return false;
	};
	tBool bGetTokenArray(Json::Value & root_in, Json::Value& root_out)
	{
		//(void)tUserAuth;
		return false;
	};
	tBool bParseDecodedIdToken(Json::Value & root_in, std::string& root_out)
	{
		//(void)tUserAuth;
		return false;
	};
};


#endif /* FC_USB_TCU_US_JSONPARSER_H_ */
